<?php
// Database connection settings
$servername = "localhost";
$username = "zxpnpszw_heinhein";
$password = "maSan122087";
$dbname = "zxpnpszw_keysever";

$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Check if POST request is received
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $key = $_POST['key'];
    $android_id = $_POST['android_id'];

    if (empty($key) || empty($android_id)) {
        echo "Key or Android ID missing";
        exit;
    }

    // Start a transaction
    $conn->begin_transaction();

    try {
        // Lock the row for the key
        $sql = "SELECT * FROM premium_keys WHERE `key` = ? FOR UPDATE";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("s", $key);
        $stmt->execute();
        $result = $stmt->get_result();

        // If key exists
        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();

            // Check if status is 'active'
            if ($row['status'] !== 'active') {
                echo "The key has expired.";
            } else {
                // Check if Android ID matches with existing records
                if ($row['android_id_1'] === $android_id || $row['android_id_2'] === $android_id) {
                    echo "keyok";
                } else {
                    // Check if android_id_1 is empty
                    if (empty($row['android_id_1'])) {
                        // Update android_id_1
                        $update_sql = "UPDATE premium_keys SET android_id_1 = ? WHERE `key` = ?";
                        $update_stmt = $conn->prepare($update_sql);
                        $update_stmt->bind_param("ss", $android_id, $key);
                        $update_stmt->execute();

                        echo "keyok";
                    } elseif (empty($row['android_id_2'])) {
                        // Update android_id_2 if android_id_1 is already set
                        $update_sql = "UPDATE premium_keys SET android_id_2 = ? WHERE `key` = ?";
                        $update_stmt = $conn->prepare($update_sql);
                        $update_stmt->bind_param("ss", $android_id, $key);
                        $update_stmt->execute();

                        echo "keyok";
                    } else {
                        echo "This key is already used on two devices.";
                    }
                }
            }
        } else {
            // Key does not exist
            echo "Wrong key";
        }

        // Commit the transaction
        $conn->commit();
    } catch (Exception $e) {
        // Rollback the transaction if something fails
        $conn->rollback();
        echo "Transaction failed: " . $e->getMessage();
    }

    $stmt->close();
}

$conn->close();
?>