<?php
session_start(); // Session ကိုစတင်ပါ

// အသုံးပြုသူသည် ဝင်ရောက်ခွင့်ရှိမရှိ စစ်ဆေးပါ
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header('Location: login.html'); // ဝင်မဖြစ်သော အခါ login စာမျက်နှာသို့ ပြန်လည်သွားရန်
    exit;
}

// Database connection details
$servername = "localhost";
$username = "zxpnpszw_heinhein";
$password = "maSan122087";
$dbname = "zxpnpszw_keysever";

$conn = new mysqli($servername, $username, $password, $dbname);

// ဆက်သွယ်မှုကို စစ်ဆေးပါ
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// လက်ရှိရက်ကို ရယူပါ
$currentDate = date('Y-m-d');

// ကာလကျောက်များအတွက် အခြေအနေကို အပ်ဒိတ်လုပ်ပါ
$updateStatusSQL = "UPDATE premium_keys SET status = 'expired' WHERE expiration_date < ? AND status = 'active'";
$stmt = $conn->prepare($updateStatusSQL);
$stmt->bind_param("s", $currentDate);
$stmt->execute();
$stmt->close();

// ရှာဖွေရန် ကိုင်တွယ်ပါ
$searchTerm = isset($_POST['search']) ? $_POST['search'] : '';

// ရှာဖွေရန် functionality နှင့် အတူ database မှ keys များကို ရယူပါ
$sql = "SELECT * FROM premium_keys WHERE `key` LIKE ? ORDER BY created_at DESC"; 
$stmt = $conn->prepare($sql);
$likeTerm = "%" . $searchTerm . "%";
$stmt->bind_param("s", $likeTerm);
$stmt->execute();
$result = $stmt->get_result();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Key Management</title>
    <style>
        table { width: 100%; border-collapse: collapse; }
        th, td { border: 1px solid #ddd; padding: 8px; }
        th { background-color: #f2f2f2; }
    </style>
</head>
<body>
    <h1>Key Management</h1>

    <form method="POST" action="">
        <input type="text" name="search" placeholder="Search by Key" value="<?php echo htmlspecialchars($searchTerm); ?>">
        <button type="submit">Search</button>
    </form>

    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Key</th>
                <th>Name</th>
                <th>Android ID 1</th>
                <th>Android ID 2</th>
                <th>Status</th>
                <th>Expiration Date</th>
                <th>Created At</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php if ($result->num_rows > 0) {
                while ($row = $result->fetch_assoc()) {
                    echo "<tr>";
                    echo "<td>{$row['id']}</td>";
                    echo "<td>{$row['key']}</td>";
                    echo "<td>{$row['name']}</td>";
                    echo "<td>{$row['android_id_1']}</td>";
                    echo "<td>{$row['android_id_2']}</td>";
                    echo "<td>{$row['status']}</td>";
                    echo "<td>{$row['expiration_date']}</td>";
                    echo "<td>{$row['created_at']}</td>";
                    echo "<td>
                        <button onclick=\"window.location.href='edit_key.php?id={$row['id']}'\">Edit</button>
                        <button onclick=\"deleteKey({$row['id']})\">Delete</button>
                    </td>";
                    echo "</tr>";
                }
            } else {
                echo "<tr><td colspan='9'>No keys found</td></tr>";
            } ?>
        </tbody>
    </table>

    <script>
        function deleteKey(id) {
            if (confirm("Are you sure you want to delete this key?")) {
                window.location.href = 'delete_key.php?id=' + id;
            }
        }
    </script>

</body>
</html>

<?php
$stmt->close();
$conn->close();
?>