<?php
// Database connection details
$servername = "localhost";
$username = "zxpnpszw_heinhein";
$password = "maSan122087";
$dbname = "zxpnpszw_keysever";

$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Handle the update
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $id = intval($_POST['id']);
    $key = $_POST['key'];
    $name = $_POST['name'];
    $android_id_1 = $_POST['android_id_1'];
    $android_id_2 = $_POST['android_id_2'];
    $expiration_date = $_POST['expiration_date'];

    // Check if the expiration date is in the future
    $currentDate = date('Y-m-d');
    $newStatus = ($expiration_date > $currentDate) ? 'active' : 'expired';

    $updateSQL = "UPDATE premium_keys SET `key` = ?, name = ?, android_id_1 = ?, android_id_2 = ?, expiration_date = ?, status = ? WHERE id = ?";
    $stmt = $conn->prepare($updateSQL);
    $stmt->bind_param("ssssssi", $key, $name, $android_id_1, $android_id_2, $expiration_date, $newStatus, $id);
    $stmt->execute();
    
    if ($stmt->affected_rows > 0) {
        echo "Key updated successfully.";
    } else {
        echo "Failed to update key.";
    }

    $stmt->close();
}

// Get the key details for the form
if (isset($_GET['id'])) {
    $id = intval($_GET['id']);
    $sql = "SELECT * FROM premium_keys WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();
    $stmt->close();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Key</title>
</head>
<body>
    <h1>Edit Key</h1>
    <form method="POST" action="">
        <input type="hidden" name="id" value="<?php echo $row['id']; ?>">
        <label for="key">Key:</label>
        <input type="text" name="key" value="<?php echo htmlspecialchars($row['key']); ?>" required>
        <br>
        <label for="name">Name:</label>
        <input type="text" name="name" value="<?php echo htmlspecialchars($row['name']); ?>" required>
        <br>
        <label for="android_id_1">Android ID 1:</label>
        <input type="text" name="android_id_1" value="<?php echo htmlspecialchars($row['android_id_1']); ?>">
        <br>
        <label for="android_id_2">Android ID 2:</label>
        <input type="text" name="android_id_2" value="<?php echo htmlspecialchars($row['android_id_2']); ?>">
        <br>
        <label for="expiration_date">Expiration Date:</label>
        <input type="date" name="expiration_date" value="<?php echo htmlspecialchars($row['expiration_date']); ?>" required>
        <br>
        <button type="submit">Update Key</button>
    </form>
    <a href="index.php">Back to Key Management</a>
</body>
</html>

<?php
$conn->close();
?>