<?php
session_start();

// Check if the user is logged in
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header('Location: login.html');  // Redirect to login page if not logged in
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Premium Key Generator</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 50px;
        }
        form, #key-form {
            width: 300px;
            margin: 0 auto;
        }
        input[type="text"], select, input[type="date"], input[type="submit"], button {
            width: 100%;
            padding: 10px;
            margin: 10px 0;
            font-size: 16px;
        }
        button {
            background-color: #4CAF50;
            color: white;
            border: none;
            cursor: pointer;
        }
        button:hover {
            background-color: #45a049;
        }
        #key-container {
            margin-top: 20px;
        }
        #key {
            font-size: 18px;
            background-color: #f0f0f0;
            padding: 10px;
            text-align: center;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 30px;
        }
        table, th, td {
            border: 1px solid black;
        }
        th, td {
            padding: 10px;
            text-align: center;
        }
        .status-active {
            color: green;
        }
        .status-expired {
            color: red;
        }
        #key-form {
            display: none;
        }
        /* New styling for search box */
        #search-box {
            width: 100%;
            padding: 10px;
            margin-bottom: 20px;
            font-size: 16px;
        }
    body {
            font-family: Arial, sans-serif;
            margin: 50px;
        }

        /* Logout button styling */
        .logout {
            position: absolute;
            top: 10px;
            right: 10px;
            background-color: red;
            color: white;
            padding: 5px 10px;
            border: none;
            font-size: 14px;
            cursor: pointer;
            border-radius: 4px;
            width: auto; /* Fix the button width */
            display: inline-block; /* Prevent the button from taking full width */
        }

        .logout:hover {
            background-color: darkred;
        }
    </style>
</head>
<body>
<!-- Logout Button -->
    <form action="logout.php" method="POST">
        <button type="submit" class="logout">Log Out</button>
    </form>
    <h1>Premium Key Generator</h1>

    <!-- Create New Key Button -->
    <button onclick="toggleKeyForm()">Create New Key</button>

    <!-- Key Form -->
    <div id="key-form">
        <form id="keyForm" method="POST">
            <label for="name">Name:</label>
            <input type="text" id="name" name="name"><br><br>

            <label for="expiration_date">Expiration Date:</label>
            <select id="expiration_date" name="expiration_date">
                <option value="1">1 Month</option>
                <option value="2">2 Months</option>
                <option value="3">3 Months</option>
                <option value="6">6 Months</option>
                <option value="custom">Custom Date</option>
            </select>
            <input type="date" id="custom_date" name="custom_date" style="display: none;"><br><br>

            <input type="submit" value="Generate Key">
        </form>
    </div>

    <!-- Key Container -->
    <div id="key-container" style="display: none;">
        <h2>Your Premium Key:</h2>
        <div id="key"></div>
        <button onclick="copyKey()">Copy Key</button>
    </div>

    <!-- Search box for filtering keys -->
    <input type="text" id="search-box" onkeyup="searchKeys()" placeholder="Search for keys...">
<!-- Modal Box HTML -->
<div id="editModal" style="display:none;">
    <div style="background-color: white; padding: 20px; border-radius: 10px; width: 400px; margin: 0 auto;">
        <h2>Edit Key</h2>
        <form id="editForm">
            <input type="hidden" id="editId" name="id">
            <label for="editName">Name:</label>
            <input type="text" id="editName" name="name"><br><br>
            <label for="editAndroidId1">Android ID 1:</label>
            <input type="text" id="editAndroidId1" name="android_id_1"><br><br>
            <label for="editAndroidId2">Android ID 2:</label>
            <input type="text" id="editAndroidId2" name="android_id_2"><br><br>
            <label for="editExpirationDate">Expiration Date:</label>
            <input type="date" id="editExpirationDate" name="expiration_date"><br><br>
            <button type="submit">Save Changes</button>
            <button type="button" onclick="closeModal()">Cancel</button>
        </form>
    </div>
</div>
    <h1>Keys List</h1>
    <div>
        <p>Active Keys: <span id="active-count" class="status-active">0</span></p>
        <p>Expired Keys: <span id="expired-count" class="status-expired">0</span></p>
    </div>
    <button onclick="deleteExpiredKeys()">Delete Expired Keys</button>
    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Key</th>
                <th>Name</th>
                <th>Android ID 1</th>
                <th>Android ID 2</th>
                <th>Status</th>
                <th>Expiration Date</th>
                <th>Created At</th>
                <th>Edit</th>
                <th>Delete</th>
            </tr>
        </thead>
        <tbody id="keys-list">
            <!-- PHP will populate this -->
        </tbody>
    </table>

    <script>
        document.getElementById('keyForm').addEventListener('submit', function(event) {
            event.preventDefault(); // Prevent form submission

            const expirationSelect = document.getElementById('expiration_date');
            const customDateInput = document.getElementById('custom_date');
            const expirationValue = expirationSelect.value;

            if (expirationValue === 'custom') {
                if (!customDateInput.value) {
                    alert('Please select a custom expiration date.');
                    return;
                }
            }

            const formData = new FormData(this);

            fetch('generate_hey.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.text()) // Expect the key as plain text
            .then(data => {
                // Show the key and copy button
                document.getElementById('key-container').style.display = 'block';
                document.getElementById('key').innerText = data; // Show the plain key
                // Load the keys list
                loadKeysList();
            })
            .catch(error => console.error('Error:', error));
        });

        document.getElementById('expiration_date').addEventListener('change', function() {
            const customDateInput = document.getElementById('custom_date');
            if (this.value === 'custom') {
                customDateInput.style.display = 'inline';
            } else {
                customDateInput.style.display = 'none';
            }
        });

        function toggleKeyForm() {
            const keyForm = document.getElementById('key-form');
            keyForm.style.display = keyForm.style.display === 'none' ? 'block' : 'none';
        }

        function copyKey() {
            const keyText = document.getElementById('key').innerText;
            navigator.clipboard.writeText(keyText).then(function() {
                alert('Key copied to clipboard: ' + keyText);
            }, function(err) {
                console.error('Could not copy key: ', err);
            });
        }

        function loadKeysList() {
            fetch('list_keys.php')
            .then(response => response.text())
            .then(data => {
                document.getElementById('keys-list').innerHTML = data;
                updateCounts(); // Update counts after loading the list
            })
            .catch(error => console.error('Error loading keys list:', error));
        }

        function updateCounts() {
            fetch('count_keys.php')
            .then(response => response.json())
            .then(data => {
                document.getElementById('active-count').innerText = data.active;
                document.getElementById('expired-count').innerText = data.expired;
            })
            .catch(error => console.error('Error loading counts:', error));
        }

        function deleteKey(id) {
            if (confirm("Are you sure you want to delete this key?")) {
                fetch(`delete_key.php?id=${id}`)
                .then(response => response.text())
                .then(data => {
                    alert(data);
                    loadKeysList(); // Refresh the list after deletion
                })
                .catch(error => console.error('Error deleting key:', error));
            }
        }

        function deleteExpiredKeys() {
            if (confirm("Are you sure you want to delete all expired keys?")) {
                fetch('delete_expired_keys.php')
                .then(response => response.text())
                .then(data => {
                    alert(data);
                    loadKeysList(); // Refresh the list after deletion
                    updateCounts(); // Refresh the counts after deletion
                })
                .catch(error => console.error('Error deleting expired keys:', error));
            }
        }

        // Search keys based on user input
        function searchKeys() {
            var input, filter, table, tr, td, i, j, txtValue;
            input = document.getElementById('search-box');
            filter = input.value.toUpperCase();
            table = document.querySelector('table tbody');
            tr = table.getElementsByTagName('tr');

            // Loop through all table rows, and hide those that don't match the search query
            for (i = 0; i < tr.length; i++) {
                tr[i].style.display = "none"; // Hide initially
                td = tr[i].getElementsByTagName('td');
                for (j = 0; j < td.length; j++) {
                    if (td[j]) {
                        txtValue = td[j].textContent || td[j].innerText;
                        if (txtValue.toUpperCase().indexOf(filter) > -1) {
                            tr[i].style.display = ""; // Show the row if a match is found
                            break; // Exit the inner loop once a match is found
                        }
                    }
                }
            }
        }

        // Load the keys list and counts when the page loads
        window.onload = function() {
            loadKeysList();
            updateCounts();
        };
    </script>

<script>
function editKey(id, name, androidId1, androidId2, expirationDate) {
    // Open the modal and populate the fields
    document.getElementById('editModal').style.display = 'block';
    document.getElementById('editId').value = id;
    document.getElementById('editName').value = name;
    document.getElementById('editAndroidId1').value = androidId1;
    document.getElementById('editAndroidId2').value = androidId2;
    document.getElementById('editExpirationDate').value = expirationDate;
}

function closeModal() {
    document.getElementById('editModal').style.display = 'none';
}

// Handle form submission for editing key
document.getElementById('editForm').addEventListener('submit', function(event) {
    event.preventDefault();

    const formData = new FormData(this);

    fetch('edit_key.php', {
        method: 'POST',
        body: formData
    })
    .then(response => response.text())
    .then(data => {
        alert(data); // Show the response from the server
        location.reload(); // Reload the page to show the updated list
    })
    .catch(error => console.error('Error:', error));
});
</script>
</body>
</html>